% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_DROPLET_09_ADHOC_GENE_3_DE_Gene.R
\name{adhocGene.DE.Gene.10x}
\alias{adhocGene.DE.Gene.10x}
\title{Differential gene expression analysis of specified gene}
\usage{
adhocGene.DE.Gene.10x(MarvelObject)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{adhocGene.TabulateExpression.Gene.10x} function.}
}
\value{
An object of class S3 with new slots \code{MarvelObject$adhocGene$DE$Gene$Data}.
}
\description{
Performs differential gene expression analysis specified gene across for all possible pairs of cell groups. The gene and cell groups were defined earlier in \code{adhocGene.TabulateExpression.Gene.10x} function.
}
\examples{

marvel.demo.10x <- readRDS(system.file("extdata/data",
                               "marvel.demo.10x.rds",
                               package="MARVEL")
                               )

marvel.demo.10x <- adhocGene.DE.Gene.10x(MarvelObject=marvel.demo.10x)

# Check output
marvel.demo.10x$adhocGene$DE$Gene$Data
}
