% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoding_functions.R
\name{viterbi}
\alias{viterbi}
\title{Viterbi algorithm for state decoding in homogeneous HMMs}
\usage{
viterbi(delta, Gamma, allprobs, trackID = NULL, mod = NULL)
}
\arguments{
\item{delta}{initial distribution of length N, or matrix of dimension c(k,N) for k independent tracks, if \code{trackID} is provided}

\item{Gamma}{transition probability matrix of dimension c(N,N) or array of transition probability matrices of dimension c(N,N,k) if \code{trackID} is provided}

\item{allprobs}{matrix of state-dependent probabilities/ density values of dimension c(n, N)}

\item{trackID}{optional vector of k track IDs, if multiple tracks need to be decoded separately}

\item{mod}{optional model object containing initial distribution \code{delta}, transition probability matrix \code{Gamma}, matrix of state-dependent probabilities \code{allprobs}, and potentially a \code{trackID} variable

If you are using automatic differentiation either with \code{RTMB::MakeADFun} or \code{\link{qreml}} and include \code{\link{forward}} in your likelihood function, the objects needed for state decoding are automatically reported after model fitting.
Hence, you can pass the model object obtained from running \code{RTMB::report()} or from \code{\link{qreml}} directly to this function.}
}
\value{
vector of decoded states of length n
}
\description{
The Viterbi algorithm allows one to decode the most probable state sequence of an HMM.
}
\examples{
delta = c(0.5, 0.5)
Gamma = matrix(c(0.9, 0.1, 0.2, 0.8), nrow = 2, byrow = TRUE)
allprobs = matrix(runif(200), nrow = 100, ncol = 2)
states = viterbi(delta, Gamma, allprobs)
}
\seealso{
Other decoding functions: 
\code{\link{stateprobs}()},
\code{\link{stateprobs_g}()},
\code{\link{stateprobs_p}()},
\code{\link{viterbi_g}()},
\code{\link{viterbi_p}()}
}
\concept{decoding functions}
