% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qreml_functions.R
\name{sdreport_outer}
\alias{sdreport_outer}
\title{Report uncertainty of the estimated smoothing parameters or variances}
\usage{
sdreport_outer(mod, invert = FALSE)
}
\arguments{
\item{mod}{model objects as returned by \code{\link{qreml}}}

\item{invert}{optional logical; if \code{TRUE}, the inverse smoothing paramaters (variances) are returned along with the transformed standard deviations obtained via the delta method.}
}
\value{
list containing \code{report} matrix summarising parameters and standard deviations as well as the outer \code{Hessian} matrix.
}
\description{
Computes standard deviations for the smoothing parameters of a model object returned by \code{qreml} using the delta method.
}
\details{
The computations are based on the approximate gradient of the restricted log likelihood. The outer Hessian is computed by finite differencing of this gradient. If the inverse smoothing parameters are requested, the standard deviations are transformed to the variances using the delta method.
}
\examples{
## no examples
}
