% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_functions.R
\name{gamma2}
\alias{gamma2}
\alias{dgamma2}
\alias{pgamma2}
\alias{qgamma2}
\alias{rgamma2}
\title{Reparametrised gamma distribution}
\usage{
dgamma2(x, mean = 1, sd = 1, log = FALSE)

pgamma2(q, mean = 1, sd = 1, lower.tail = TRUE, log.p = FALSE)

qgamma2(p, mean = 1, sd = 1, lower.tail = TRUE, log.p = FALSE)

rgamma2(n, mean = 1, sd = 1)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mean}{mean parameter, must be positive scalar.}

\item{sd}{standard deviation parameter, must be positive scalar.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X <= x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{dgamma2} gives the density, \code{pgamma2} gives the distribution function, \code{qgamma2} gives the quantile function, and \code{rgamma2} generates random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
the gamma distribution reparametrised in terms of mean and standard deviation.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.
}
\examples{
x = rgamma2(1)
d = dgamma2(x)
p = pgamma2(x)
q = qgamma2(p)
}
