% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{group_data_by_dims}
\alias{group_data_by_dims}
\title{Group Data by Dimension Patterns in SL4 or HAR Objects}
\usage{
group_data_by_dims(
  patterns = NULL,
  ...,
  priority,
  rename_cols = NULL,
  experiment_names = NULL,
  subtotal_level = FALSE,
  auto_rename = FALSE
)
}
\arguments{
\item{patterns}{Character vector. Dimension patterns to extract. Use \code{"ALL"} or \code{NULL} to extract all available patterns.}

\item{...}{One or more SL4 or HAR objects loaded using \code{load_sl4x()} or \code{load_harx()}.}

\item{priority}{Named list. Specifies priority dimension elements (\code{c("group_name" = c("dim1", "dim2"))}).}

\item{rename_cols}{Named vector. Column name replacements (\code{c("old_name" = "new_name")}).}

\item{experiment_names}{Character vector. Names assigned to each dataset. If \code{NULL}, names are inferred.}

\item{subtotal_level}{Character or logical. Determines which decomposition levels to retain:
\itemize{
\item \code{"total"}: Keeps only \code{"TOTAL"} values.
\item \code{"decomposed"}: Keeps only decomposed values (excludes \code{"TOTAL"}).
\item \code{"all"}: Keeps all rows.
\item \code{TRUE}: Equivalent to \code{"all"}, retaining both \code{"TOTAL"} and decomposed values.
\item \code{FALSE}: Equivalent to \code{"total"}, keeping only \code{"TOTAL"} values.
}}

\item{auto_rename}{Logical. If \code{TRUE}, automatically renames dimensions for consistency. Default is \code{FALSE}.}
}
\value{
A structured list of grouped data:
\itemize{
\item A named list where each element corresponds to a dimension size group (e.g., "2D", "3D").
\item Each group contains dimension-grouped data based on priority rules.
\item If unmerged data exists, includes a report attribute detailing merge issues.
}
}
\description{
Groups extracted SL4 or HAR data based on specified dimension structures and priority rules.
Supports automatic renaming, merging, subtotal filtering, and structured metadata handling.
}
\details{
\itemize{
\item Groups extracted variables based on dimension elements.
\item Applies predefined priority rules to structure the data.
\item Allows automatic renaming of dimensions (\code{auto_rename = TRUE}).
\item Supports merging of grouped data across multiple experiments.
\item Handles subtotal filtering (\code{subtotal_level}), controlling whether \code{"TOTAL"} or decomposed values are retained.
}
}
\examples{
# Import sample data
sl4_data1 <- load_sl4x(system.file("extdata", "TAR10.sl4", package = "HARplus"))
sl4_data2 <- load_sl4x(system.file("extdata", "SUBT10.sl4", package = "HARplus"))

# Case 1: Multiple priority levels (Sector then Region) with auto_rename
priority_list <- list(
  "Sector" = c("COMM", "ACTS"),
  "Region" = c("REG")
)
grouped_data_multiple <- group_data_by_dims(
  patterns = "ALL",
  sl4_data1,
  priority = priority_list,
  auto_rename = TRUE
)

# Case 2: Single priority (Region only) with auto_rename
priority_list <- list("Region" = c("REG"))
grouped_data_single <- group_data_by_dims(
  patterns = "ALL",
  sl4_data1, sl4_data2,
  priority = priority_list,
  auto_rename = TRUE
)

# Case 3: Multiple priorities without auto_rename
priority_list <- list(
  "Sector" = c("COMM", "ACTS"),
  "Region" = c("REG")
)
grouped_data_no_rename <- group_data_by_dims(
  patterns = "ALL",
  sl4_data1,
  priority = priority_list,
  auto_rename = FALSE
)
}
\seealso{
\code{\link{get_data_by_dims}}, \code{\link{get_data_by_var}}, \code{\link{load_sl4x}}, \code{\link{load_harx}}
}
\author{
Pattawee Puangchit
}
