% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{runNMF}
\alias{runNMF}
\title{Compute NMF as a low-dim embedding for Seurat}
\usage{
runNMF(
  obj,
  assay = "RNA",
  slot = "data",
  k = 10,
  new.reduction = "NMF",
  seed = 123,
  L1 = c(0, 0),
  hvg = NULL,
  center = FALSE,
  scale = FALSE
)
}
\arguments{
\item{obj}{A seurat object}

\item{assay}{Get data matrix from this assay}

\item{slot}{Get data matrix from this slot (=layer)}

\item{k}{Number of components for low-dim representation}

\item{new.reduction}{Name of new dimensionality reduction}

\item{seed}{Random seed}

\item{L1}{L1 regularization term for NMF}

\item{hvg}{Which genes to use for the reduction}

\item{center}{Whether to center the data matrix}

\item{scale}{Whether to scale the data matrix}
}
\value{
Returns a Seurat object with a new dimensionality reduction (NMF)
}
\description{
Compute NMF embeddings for single-cell dataset, and store them in the Seurat data
structure. They can be used as an alternative to PCA for downstream analyses.
}
\examples{
data(sampleObj)
sampleObj <- runNMF(sampleObj, k=8)
}
