% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_gp.R
\name{predict_gp}
\alias{predict_gp}
\title{predict_gp}
\usage{
predict_gp(out, xx)
}
\arguments{
\item{out}{out from \code{\link{mle_gp}} or \code{\link{mle_gp}}.}

\item{xx}{A numerical vector or matrix of new input locations.}
}
\value{
A list of predictive posterior mean and covariance:
\itemize{
\item \code{mup}: vector of predicted posterior mean
\item \code{Sigmap}: predictive posterior covariance matrix
}
}
\description{
Computes the posterior mean and covariance matrix for a given set of
input locations based on a fitted model.
}
\details{
From the model fitted by \code{\link{mle_gp}} or \code{\link{mle_gp}}, the posterior mean and
covariance matrix are computed.
}
\examples{

### test function ###
f_x <- function(x) {
return(sin(2*pi*x) + x^2)
}

### training data ###
n <- 8
x <- runif(n, 0, 1)
y <- f_x(x)

### testing data ###
n.test <- 100
x.test <- runif(n.test, 0, 1)
y.test <- f_x(x.test)

### get parameter estimates ###
out <- mle_gp(y, x)

### prediction ###
pred <- predict_gp(out, x.test)


}
