% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pointsAboveTreeline}
\alias{pointsAboveTreeline}
\title{Points on or above the treeline}
\format{
A data frame with 511'930 rows and 2 variables:
\describe{
\item{longitude}{Longitude of the point (in degrees; WGS 84).}
\item{latitude}{Latitude of the point (in degrees; WGS 84).}
}
}
\source{
gstRaster: \url{https://os.zhdk.cloud.switch.ch/chelsav2/GLOBAL/climatologies/1981-2010/bio/CHELSA_gst_1981-2010_V.2.1.tif}

gslRaster: \url{https://os.zhdk.cloud.switch.ch/chelsav2/GLOBAL/climatologies/1981-2010/bio/CHELSA_gsl_1981-2010_V.2.1.tif}
}
\usage{
pointsAboveTreeline
}
\description{
A data set containing 133,302 points on or above the treeline.
The data set was generated with the function \code{generate_point_df}.
For the \code{gstRaster} (growing season temperature) and the \code{gslRaster}
(growing season length) raster layers from CHELSA V2.1 are used (see source),
the \code{stepSize} is set to 0.0416666 degrees.
The thresholds and the treeline definition is based on Paulsen and Körner,
Alp. Bot. 124: 1-12 (2014). The GMBA mountain inventory V1.2 was used to
remove points that do not lie within steep terrain.
}
\keyword{datasets}
