% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_distance.R
\name{calculate_distance}
\alias{calculate_distance}
\title{Sample and calculate the distance to the local treeline}
\usage{
calculate_distance(treeline, elevationRaster, pointElevation, treelineSampling = 10,
                         plot = FALSE)
}
\arguments{
\item{treeline}{A data frame containing line-shaped polygons. Each row containing: a identifier, a start latitude and
longitude, an end latitude and longitude. All longitude and latitude (WGS 84) parameters must be of the data type "numeric" and finite.}

\item{elevationRaster}{Raster that contains a digital elevation model. Data type "SpatRaster".}

\item{pointElevation}{Elevation of the point of interest (in meters above the sea level). One value, data type "numeric" and finite.}

\item{treelineSampling}{A constant number of samples taken from one "treeline piece". One value, data type "integer", finite and not zero.}

\item{plot}{Boolean that defines if a histogram of the sampled elevation is plotted.
The plot will only be shown if the value is \code{TRUE}.}
}
\value{
Returns a numeric representing the vertical distance to the local treeline in meters.
}
\description{
Points are uniformly drawn along polygons that specify the treeline. The elevation of each point is then extracted
and the median elevation of all points is calculated. Finally the median treeline elevation is subtracted from the
\code{pointElevation} to get its distance to the local treeline.
}
\examples{
\dontrun{
calculate_distance(treeline = dfTreeline, elevationRaster = GTOPO30, pointElevation = 512,
                   treelineSampling = 10, plot = FALSE)
}
}
\author{
Livio Bätscher, Jurriaan M. de Vos
}
