% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN_seq.R
\name{mts_dataset}
\alias{mts_dataset}
\title{Dataset creator for sequential data}
\usage{
mts_dataset(
  Y,
  X,
  seq_len,
  intermediate_quantiles = NULL,
  scale_Y = TRUE,
  fold_separation = NULL,
  sample_frac = 1,
  device = EQRN::default_device()
)
}
\arguments{
\item{Y}{Response variable vector to model the extreme conditional quantile of, for training. Entries must be in sequential order.}

\item{X}{Matrix of covariates, for training. Entries must be in sequential order.}

\item{seq_len}{Data sequence length (i.e. number of past observations) used during training to predict each response quantile.}

\item{intermediate_quantiles}{Vector of intermediate conditional quantiles at level \code{interm_lvl}.}

\item{scale_Y}{Whether to rescale the response past, when considered as an input covariate,
to zero mean and unit covariance before applying the network (recommended).}

\item{fold_separation}{Fold separation index, when using concatenated folds as data.}

\item{sample_frac}{Value between \code{0} and \code{1}. If \code{sample_frac < 1}, a subsample of the data is used. Defaults to \code{1}.}

\item{device}{(optional) A \code{\link[torch:torch_device]{torch::torch_device()}}. Defaults to \code{\link[=default_device]{default_device()}}.}
}
\value{
The \code{\link[torch:dataset]{torch::dataset}} containing the given data, to be used with a recurrent neural network.
}
\description{
A \code{torch::dataset} object that can be initialized with sequential data,
used to feed a recurrent network during training or prediction.
It is used in \code{\link[=EQRN_fit_seq]{EQRN_fit_seq()}} and corresponding predict functions,
as well as in other recurrent methods such as \code{\link[=QRN_seq_fit]{QRN_seq_fit()}} and its predict functions.
It can perform scaling of the response's past as a covariate, and compute excesses as a response when used in \code{\link[=EQRN_fit_seq]{EQRN_fit_seq()}}.
It also allows for fold separation or sequential discontinuity in the data.
}
