% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egm.R
\name{egm}
\alias{egm}
\alias{is_egm}
\title{Electrogram data class from electrophysiology studies}
\usage{
egm(
  signal = signal_table(),
  header = header_table(),
  annotation = annotation_table(),
  ...
)

is_egm(x)
}
\arguments{
\item{signal}{A \code{signal_table} object generated by the \code{\link[=signal_table]{signal_table()}}
function}

\item{header}{A \code{header_table} object generated by the \code{\link[=header_table]{header_table()}}
function}

\item{annotation}{A \code{annotation_table} object generated by the
\code{\link[=annotation_table]{annotation_table()}} function}

\item{...}{Additional arguments to be passed to the function}

\item{x}{An \code{egm} object, typically generated by the \code{\link[=egm]{egm()}} function, to be
used with support functions (e.g. \code{\link[=is_egm]{is_egm()}}}
}
\value{
An object of class \code{egm} that is always a list of the above three
components. Oftentimes, the \code{annotation_table} object may be missing, and
it is replaced with an empty table as a place holder.
}
\description{
This class serves as a combinatorial class to describe
cardiovascular electrical signal data in R. It is based off of the formats
available in WFDB, but has been formatted for ease of use within the \code{R}
ecosystem. An \code{egm} object contains three components in a list:
\itemize{
\item signal data in multiple channels
\item header information
\item annotation labels at specified time points
}

These components help to navigate, and visualize data. The \code{egm} class is
the backbone for working with WFDB objects in R, and provides an interface
for integrating or converting other raw signal data to a WFDB format.
}
\details{
The individual components of the class are further defined in their
respective children functions \code{\link[=signal_table]{signal_table()}}, \code{\link[=header_table]{header_table()}},
\code{\link[=annotation_table]{annotation_table()}}. They are very simple classes that build upon the
\code{data.table} class that allow for class safety checks when working with
different data types (particularly WFDB).

\strong{IMPORTANT}: The \code{egm} class can be built from ground-up by the user,
however it is primarily generated for the user using the other read/write
functions, such as \code{\link[=read_lspro]{read_lspro()}} or \code{\link[=read_wfdb]{read_wfdb()}}.
}
