% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecos.R
\name{ECOS_update}
\alias{ECOS_update}
\title{Update numerical data in an ECOS workspace}
\usage{
ECOS_update(workspace, Gpr = NULL, Apr = NULL, c = NULL, h = NULL, b = NULL)
}
\arguments{
\item{workspace}{an external pointer of class \code{"ecos_workspace"}
as returned by \code{\link{ECOS_setup}}.}

\item{Gpr}{numeric vector of new non-zero values for G (same length
as original), or \code{NULL} to keep current values.}

\item{Apr}{numeric vector of new non-zero values for A (same length
as original), or \code{NULL} to keep current values.}

\item{c}{numeric vector of new objective coefficients, or \code{NULL}.}

\item{h}{numeric vector of new inequality RHS, or \code{NULL}.}

\item{b}{numeric vector of new equality RHS, or \code{NULL}.}
}
\value{
the \code{workspace} object, invisibly.
}
\description{
Replaces numerical values in an existing ECOS workspace without
repeating symbolic analysis. The sparsity structure must remain
the same; only the non-zero values of G and A, and the dense
vectors c, h, b can be updated. Pass \code{NULL} for any argument
to leave it unchanged.
}
\seealso{
\code{\link{ECOS_setup}}, \code{\link{ECOS_solve}},
  \code{\link{ECOS_cleanup}}
}
