% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_var_hp.R
\name{mean_var_hp}
\alias{mean_var_hp}
\alias{mean_var_hp2}
\title{Mean and variance for hyper-Poisson distribution}
\usage{
mean_var_hp(mu, sigma)

mean_var_hp2(mu, sigma)
}
\arguments{
\item{mu}{value of the mu parameter.}

\item{sigma}{value of the sigma parameter.}
}
\value{
the function returns a list with the mean and variance.
}
\description{
This function calculates the mean and variance for the
hyper-Poisson distribution with parameters \eqn{\mu} and \eqn{\sigma}.
}
\details{
The hyper-Poisson distribution with parameters \eqn{\mu} and \eqn{\sigma}
has a support 0, 1, 2, ... and density given by

\eqn{f(x | \mu, \sigma) = \frac{\mu^x}{_1F_1(1;\mu;\sigma)}\frac{\Gamma(\sigma)}{\Gamma(x+\sigma)}}

where the function \eqn{_1F_1(a;c;z)} is defined as

\eqn{_1F_1(a;c;z) = \sum_{r=0}^{\infty}\frac{(a)_r}{(c)_r}\frac{z^r}{r!}}

and \eqn{(a)_r = \frac{\gamma(a+r)}{\gamma(a)}} for \eqn{a>0} and \eqn{r} positive integer.

This function calculates the mean and variance of this distribution.
}
\examples{
# Example 1

# Theoretical values
mean_var_hp(mu=5.5, sigma=0.1)

# Using simulated values
y <- rHYPERPO(n=1000, mu=5.5, sigma=0.1)
mean(y)
var(y)


# Example 2

# Theoretical values
mean_var_hp2(mu=5.5, sigma=1.9)

# Using simulated values
y <- rHYPERPO2(n=1000, mu=5.5, sigma=1.9)
mean(y)
var(y)
}
\references{
Sáez-Castillo, A. J., & Conde-Sánchez, A. (2013). A hyper-Poisson regression model for overdispersed and underdispersed count data. Computational Statistics & Data Analysis, 61, 148-157.
}
\seealso{
\link{HYPERPO}.
}
\author{
Freddy Hernandez, \email{fhernanb@unal.edu.co}
}
