% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbIsValid,DatabaseConnectorJdbcConnection-method}
\alias{dbIsValid,DatabaseConnectorJdbcConnection-method}
\title{Is this DBMS object still valid?}
\usage{
\S4method{dbIsValid}{DatabaseConnectorJdbcConnection}(dbObj, ...)
}
\arguments{
\item{dbObj}{An object inheriting from \link[DBI:DBIObject-class]{DBIObject},
i.e. \link[DBI:DBIDriver-class]{DBIDriver}, \link[DBI:DBIConnection-class]{DBIConnection},
or a \link[DBI:DBIResult-class]{DBIResult}}

\item{...}{Other arguments to methods.}
}
\value{
\code{dbIsValid()} returns a logical scalar,
\code{TRUE} if the object specified by \code{dbObj} is valid,
\code{FALSE} otherwise.
A \link[DBI:DBIConnection-class]{DBIConnection} object is initially valid,
and becomes invalid after disconnecting with \code{\link[DBI:dbDisconnect]{dbDisconnect()}}.
For an invalid connection object (e.g., for some drivers if the object
is saved to a file and then restored), the method also returns \code{FALSE}.
A \link[DBI:DBIResult-class]{DBIResult} object is valid after a call to \code{\link[DBI:dbSendQuery]{dbSendQuery()}},
and stays valid even after all rows have been fetched;
only clearing it with \code{\link[DBI:dbClearResult]{dbClearResult()}} invalidates it.
A \link[DBI:DBIResult-class]{DBIResult} object is also valid after a call to \code{\link[DBI:dbSendStatement]{dbSendStatement()}},
and stays valid after querying the number of rows affected;
only clearing it with \code{\link[DBI:dbClearResult]{dbClearResult()}} invalidates it.
If the connection to the database system is dropped (e.g., due to
connectivity problems, server failure, etc.), \code{dbIsValid()} should return
\code{FALSE}. This is not tested automatically.
}
\description{
This generic tests whether a database object is still valid (i.e. it hasn't
been disconnected or cleared).

}
\seealso{
Other DBIDriver generics: 
\code{\link[DBI]{DBIDriver-class}},
\code{\link[DBI]{dbCanConnect}()},
\code{\link[DBI]{dbConnect}()},
\code{\link[DBI]{dbDataType}()},
\code{\link[DBI]{dbDriver}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbListConnections}()}

Other DBIConnection generics: 
\code{\link[DBI]{DBIConnection-class}},
\code{\link[DBI]{dbAppendTable}()},
\code{\link[DBI]{dbAppendTableArrow}()},
\code{\link[DBI]{dbCreateTable}()},
\code{\link[DBI]{dbCreateTableArrow}()},
\code{\link[DBI]{dbDataType}()},
\code{\link[DBI]{dbDisconnect}()},
\code{\link[DBI]{dbExecute}()},
\code{\link[DBI]{dbExistsTable}()},
\code{\link[DBI]{dbGetException}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetQuery}()},
\code{\link[DBI]{dbGetQueryArrow}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbListFields}()},
\code{\link[DBI]{dbListObjects}()},
\code{\link[DBI]{dbListResults}()},
\code{\link[DBI]{dbListTables}()},
\code{\link[DBI]{dbQuoteIdentifier}()},
\code{\link[DBI]{dbReadTable}()},
\code{\link[DBI]{dbReadTableArrow}()},
\code{\link[DBI]{dbRemoveTable}()},
\code{\link[DBI]{dbSendQuery}()},
\code{\link[DBI]{dbSendQueryArrow}()},
\code{\link[DBI]{dbSendStatement}()},
\code{\link[DBI]{dbUnquoteIdentifier}()},
\code{\link[DBI]{dbWriteTable}()},
\code{\link[DBI]{dbWriteTableArrow}()}

Other DBIResult generics: 
\code{\link[DBI]{DBIResult-class}},
\code{\link[DBI]{dbBind}()},
\code{\link[DBI]{dbClearResult}()},
\code{\link[DBI]{dbColumnInfo}()},
\code{\link[DBI]{dbFetch}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetRowCount}()},
\code{\link[DBI]{dbGetRowsAffected}()},
\code{\link[DBI]{dbGetStatement}()},
\code{\link[DBI]{dbHasCompleted}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbQuoteLiteral}()},
\code{\link[DBI]{dbQuoteString}()}

Other DBIResultArrow generics: 
\code{\link[DBI]{DBIResultArrow-class}},
\code{\link[DBI]{dbBind}()},
\code{\link[DBI]{dbClearResult}()},
\code{\link[DBI]{dbFetchArrow}()},
\code{\link[DBI]{dbFetchArrowChunk}()},
\code{\link[DBI]{dbHasCompleted}()}
}
