% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_max_min_values.R
\name{get_max_min_values}
\alias{get_max_min_values}
\title{Finds peak (or lowest) model output values}
\usage{
get_max_min_values(data, tmin, tmax, Dt_max = TRUE)
}
\arguments{
\item{data}{A list of data.frames (one data.frame for each policy
alternative).}

\item{tmin}{A numeric value or a date specifying the minimum simulation time
to include in the analysis (ex. 1 or "2021-01-01"). This should correspond to a value in the first
column of each data.frame in \code{data}.}

\item{tmax}{A numeric value or a date specifying the maximum simulation time to
include in the analysis (ex. 100 or "2021-04-10"). This should correspond to a value in the first
column of each data.frame in \code{data}.}

\item{Dt_max}{A logical value indicating whether the decision threshold
is a maximum (\code{TRUE}) or a minimum (\code{FALSE}). The default is \code{TRUE}.}
}
\value{
A list of data.frame(s) containing the peak (or lowest)
value and corresponding simulation time for each policy alternative.
}
\description{
For each policy alternative, this function finds the peak
(or lowest if the threshold is a minimum) model output values for
each simulation run.
}
\section{data format}{

Each data.frame in \code{data} contains the results from multiple model
runs using different parameter sets (e.g., from probabilistic sensitivity,
uncertainty, or Bayesian inference analysis). The first column contains
the model time and subsequent columns contain the predicted output for
each simulation run at the respective time.
The model time in the first column must contain numeric values indicating
a simulation time (ex. 1, 2, 3,...) or dates (ex. "2021-01-01", "2021-01-02")
which must be in \code{R} Date format (i.e., class="Date"). To ensure a consistent
basis for comparison, the model time in the first column should be the same for
each policy alternative (data.frame).
}

\examples{
tmin <- "2021-01-01"
tmax <- "2021-04-10"
Dt <- rep(750, nrow(psa_data$Baseline))

peak_values_list <- get_max_min_values(
  psa_data,
  tmin = tmin,
  tmax = tmax,
  Dt_max = TRUE
)
}
