% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cms_download_subset.r
\name{cms_download_subset}
\alias{cms_download_subset}
\title{Subset and download a specific marine product from Copernicus}
\usage{
cms_download_subset(
  username = cms_get_username(),
  password = cms_get_password(),
  destination,
  product,
  layer,
  variable,
  region,
  timerange,
  verticalrange,
  overwrite = FALSE
)
}
\arguments{
\item{username}{Your Copernicus marine user name. Can be provided with
\code{cms_get_username()} (default), or as argument here.}

\item{password}{Your Copernicus marine password. Can be provided as
\code{cms_get_password()} (default), or as argument here.}

\item{destination}{File or path where the requested file will be downloaded to.}

\item{product}{An identifier (type \code{character}) of the desired Copernicus marine product.
Can be obtained with \code{\link{cms_products_list}}.}

\item{layer}{The name of a desired layer within a product (type \code{character}). Can be obtained with \code{\link{cms_product_details}}.}

\item{variable}{The name of a desired variable in a specific layer of a product (type \code{character}).
Can be obtained with \code{\link{cms_product_details}}.}

\item{region}{Specification of the bounding box as a \code{vector} of \code{numeric}s WGS84 lat and lon coordinates.
Should be in the order of: xmin, ymin, xmax, ymax.}

\item{timerange}{A \code{vector} with two elements (lower and upper value)
for a requested time range. The \code{vector} should be coercible to \code{POSIXct}.}

\item{verticalrange}{A \code{vector} with two elements (minimum and maximum)
numerical values for the depth of the vertical layers (if any). Note that values below the
sea surface needs to be specified as negative values.}

\item{overwrite}{A \code{logical} value. When \code{FALSE} (default), files at the \code{destination} won't be
overwritten when the exist. Instead an error will be thrown if this is the case. When set to
\code{TRUE}, existing files will be overwritten.}
}
\value{
Returns a \code{logical} value invisibly indicating whether the requested file was
successfully stored at the \code{destination}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}} Subset and download a specific marine product from Copernicus.
You need to register an account
at \url{https://data.marine.copernicus.eu} before you can use this function.
}
\examples{
\dontrun{
destination <- tempfile("copernicus", fileext = ".nc")

## Assuming that Copernicus account details are provided as `options`
cms_download_subset(
  destination   = destination,
  product       = "GLOBAL_ANALYSISFORECAST_PHY_001_024",
  layer         = "cmems_mod_glo_phy-cur_anfc_0.083deg_P1D-m",
  variable      = "sea_water_velocity",
  region        = c(-1, 50, 10, 55),
  timerange     = c("2021-01-01 UTC", "2021-01-02 UTC"),
  verticalrange = c(0, -2)
)

mydata <- stars::read_stars(destination)

plot(mydata["vo"])
}
}
\author{
Pepijn de Vries
}
