% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cms_product_details.r
\name{cms_product_details}
\alias{cms_product_details}
\title{Obtain details for a specific Copernicus marine product}
\usage{
cms_product_details(product, layer, variant, ...)
}
\arguments{
\item{product}{An identifier (type \code{character}) of the desired Copernicus marine product.
Can be obtained with \code{\link{cms_products_list}}.}

\item{layer}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Ignored and deprecated}

\item{variant}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Ignored and deprecated}

\item{...}{Ignored}
}
\value{
Returns a named \code{list} with product details.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Obtain details for a specific Copernicus marine product.
}
\examples{
if (interactive()) {
  cms_product_details("GLOBAL_ANALYSISFORECAST_PHY_001_024")
}
}
\seealso{
Other product-functions: 
\code{\link{cms_cite_product}()},
\code{\link{cms_product_services}()},
\code{\link{cms_products_list}()}
}
\author{
Pepijn de Vries
}
\concept{product-functions}
