% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_DataUploadServer.R
\name{shiny_dataUploadServer}
\alias{shiny_dataUploadServer}
\title{Shiny Module Server for Data Upload and Processing}
\usage{
shiny_dataUploadServer(id)
}
\arguments{
\item{id}{A character string that corresponds to the ID used in the UI function
for this module.}
}
\value{
A reactive expression containing the tidied data frame with the following columns:

  \itemize{
    \item Date: Date and time, floored to the hour
    \item Sensor: Sensor identifier
    \item Site: Site identifier
    \item Temp: Median average temperature for each hour
    \item RH: Median average relative humidity for each hour
  }
}
\description{
This function creates a Shiny module server for uploading CSV or Excel files,
processing the data, and returning a tidied dataset.
}
\examples{
if(interactive()) {

# In a Shiny app:
ui <- fluidPage(
  shiny_dataUploadUI("dataUpload")
)

server <- function(input, output, session) {
  data <- shiny_dataUploadServer("dataUpload")
}

}


}
