% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunCohortGeneration.R
\name{runCohortGeneration}
\alias{runCohortGeneration}
\title{Run a cohort generation and export results}
\usage{
runCohortGeneration(
  connectionDetails,
  cdmDatabaseSchema,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  cohortDatabaseSchema = cdmDatabaseSchema,
  cohortTableNames = getCohortTableNames(),
  cohortDefinitionSet = NULL,
  negativeControlOutcomeCohortSet = NULL,
  occurrenceType = "all",
  detectOnDescendants = FALSE,
  stopOnError = TRUE,
  outputFolder,
  databaseId = 1,
  minCellCount = 5,
  incremental = FALSE,
  incrementalFolder = NULL
)
}
\arguments{
\item{connectionDetails}{An object of type \code{connectionDetails} as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package.}

\item{cdmDatabaseSchema}{Schema name where your patient-level data in OMOP CDM format resides.
Note that for SQL Server, this should include both the database and
schema name, for example 'cdm_data.dbo'.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support
temp tables. To emulate temp tables, provide a schema with write
privileges where temp tables can be created.}

\item{cohortDatabaseSchema}{Schema name where your cohort tables reside. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{cohortTableNames}{The names of the cohort tables. See \code{\link{getCohortTableNames}}
for more details.}

\item{cohortDefinitionSet}{The \code{cohortDefinitionSet} argument must be a data frame with 
the following columns: \describe{
\item{cohortId}{The unique integer identifier of the cohort} 
\item{cohortName}{The cohort's name}
\item{sql}{The OHDSI-SQL used to generate the cohort}}
Optionally, this data frame may contain: \describe{
\item{json}{The Circe JSON representation of the cohort}}}

\item{negativeControlOutcomeCohortSet}{The \code{negativeControlOutcomeCohortSet} argument must be a data frame with 
the following columns: \describe{
\item{cohortId}{The unique integer identifier of the cohort} 
\item{cohortName}{The cohort's name}
\item{outcomeConceptId}{The concept_id in the condition domain to use for the negative control outcome.}}}

\item{occurrenceType}{For negative controls outcomes, the occurrenceType
will detect either: the first time an
outcomeConceptId occurs or all times the
outcomeConceptId occurs for a person. Values
accepted: 'all' or 'first'.}

\item{detectOnDescendants}{For negative controls outcomes, when set to TRUE,
detectOnDescendants will use the vocabulary to
find negative control outcomes using the
outcomeConceptId and all descendants via the
concept_ancestor table. When FALSE, only the exact
outcomeConceptId will be used to detect the
outcome.}

\item{stopOnError}{If an error happens while generating one of the
cohorts in the cohortDefinitionSet, should we
stop processing the other cohorts? The default is
TRUE; when set to FALSE, failures will be
identified in the return value from this function.}

\item{outputFolder}{Name of the folder where all the outputs will written to.}

\item{databaseId}{A unique ID for the database. This will be appended to
most tables.}

\item{minCellCount}{To preserve privacy: the minimum number of subjects contributing
to a count before it can be included in the results. If the
count is below this threshold, it will be set to `-minCellCount`.}

\item{incremental}{Create only cohorts that haven't been created before?}

\item{incrementalFolder}{If \code{incremental = TRUE}, specify a folder where
records are kept of which definition has been
executed.}
}
\description{
Run a cohort generation and export results
}
\details{
Run a cohort generation for a set of cohorts and negative control outcomes.
This function will also export the results of the run to the `outputFolder`.
}
