% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CohortTables.R
\name{createCohortTables}
\alias{createCohortTables}
\title{Create cohort tables}
\usage{
createCohortTables(
  connectionDetails = NULL,
  connection = NULL,
  cohortDatabaseSchema,
  cohortTableNames = getCohortTableNames(),
  incremental = FALSE
)
}
\arguments{
\item{connectionDetails}{An object of type \code{connectionDetails} as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package. Can be left NULL if \code{connection} is
provided.}

\item{connection}{An object of type \code{connection} as created using the
\code{\link[DatabaseConnector]{connect}} function in the
DatabaseConnector package. Can be left NULL if \code{connectionDetails}
is provided, in which case a new connection will be opened at the start
of the function, and closed when the function finishes.}

\item{cohortDatabaseSchema}{Schema name where your cohort tables reside. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{cohortTableNames}{The names of the cohort tables. See \code{\link{getCohortTableNames}}
for more details.}

\item{incremental}{When set to TRUE, this function will check to see
if the cohortTableNames exists in the cohortDatabaseSchema
and if they exist, it will skip creating the tables.}
}
\description{
This function creates an empty cohort table and empty tables for
cohort statistics.
}
