% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Subsets.R
\name{LimitSubsetOperator}
\alias{LimitSubsetOperator}
\title{Limit Subset Operator}
\description{
operator to apply limiting subset operations (e.g. washout periods, calendar ranges or earliest entries)

Get auto generated name
}
\section{Super class}{
\code{\link[CohortGenerator:SubsetOperator]{CohortGenerator::SubsetOperator}} -> \code{LimitSubsetOperator}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{priorTime}}{minimum washout time in days}

\item{\code{followUpTime}}{minimum required follow up time in days}

\item{\code{minimumCohortDuration}}{minimum cohort duration time in days}

\item{\code{limitTo}}{character one of:
                             "firstEver" - only first entry in patient history
                             "earliestRemaining" - only first entry after washout set by priorTime
                             "latestRemaining" -  the latest remaining after washout set by followUpTime
                             "lastEver" - only last entry in patient history inside

                         Note, when using firstEver and lastEver with follow up and washout, patients with events
                         outside this will be censored.}

\item{\code{calendarStartDate}}{The calendar start date for limiting by date}

\item{\code{calendarEndDate}}{The calendar end date for limiting by date}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LimitSubsetOperator-getAutoGeneratedName}{\code{LimitSubsetOperator$getAutoGeneratedName()}}
\item \href{#method-LimitSubsetOperator-toList}{\code{LimitSubsetOperator$toList()}}
\item \href{#method-LimitSubsetOperator-clone}{\code{LimitSubsetOperator$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="CohortGenerator" data-topic="SubsetOperator" data-id="classname"><a href='../../CohortGenerator/html/SubsetOperator.html#method-SubsetOperator-classname'><code>CohortGenerator::SubsetOperator$classname()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CohortGenerator" data-topic="SubsetOperator" data-id="getQueryBuilder"><a href='../../CohortGenerator/html/SubsetOperator.html#method-SubsetOperator-getQueryBuilder'><code>CohortGenerator::SubsetOperator$getQueryBuilder()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CohortGenerator" data-topic="SubsetOperator" data-id="initialize"><a href='../../CohortGenerator/html/SubsetOperator.html#method-SubsetOperator-initialize'><code>CohortGenerator::SubsetOperator$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CohortGenerator" data-topic="SubsetOperator" data-id="isEqualTo"><a href='../../CohortGenerator/html/SubsetOperator.html#method-SubsetOperator-isEqualTo'><code>CohortGenerator::SubsetOperator$isEqualTo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CohortGenerator" data-topic="SubsetOperator" data-id="publicFields"><a href='../../CohortGenerator/html/SubsetOperator.html#method-SubsetOperator-publicFields'><code>CohortGenerator::SubsetOperator$publicFields()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CohortGenerator" data-topic="SubsetOperator" data-id="toJSON"><a href='../../CohortGenerator/html/SubsetOperator.html#method-SubsetOperator-toJSON'><code>CohortGenerator::SubsetOperator$toJSON()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LimitSubsetOperator-getAutoGeneratedName"></a>}}
\if{latex}{\out{\hypertarget{method-LimitSubsetOperator-getAutoGeneratedName}{}}}
\subsection{Method \code{getAutoGeneratedName()}}{
name generated from subset operation properties
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LimitSubsetOperator$getAutoGeneratedName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
To List
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LimitSubsetOperator-toList"></a>}}
\if{latex}{\out{\hypertarget{method-LimitSubsetOperator-toList}{}}}
\subsection{Method \code{toList()}}{
List representation of object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LimitSubsetOperator$toList()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LimitSubsetOperator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LimitSubsetOperator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LimitSubsetOperator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
