% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Subset.R
\name{Subset}
\alias{Subset}
\title{Subset a Data Array}
\usage{
Subset(x, along, indices, drop = FALSE)
}
\arguments{
\item{x}{A named multidimensional array to be sliced. It can have dimension 
names either in \code{names(dim(x))} or in the attribute 'dimensions'.}

\item{along}{A vector with references to the dimensions to take the subset 
from: either integers or dimension names.}

\item{indices}{A list of indices to take from each dimension specified in 
'along'. If a single dimension is specified in 'along', it can be directly
provided as an integer or a vector.}

\item{drop}{Whether to drop all the dimensions of length 1 in the resulting 
array, none, only those that are specified in 'along', or only those that 
are not specified in 'along'. The possible values are: 'all' or TRUE, 'none'
or FALSE, 'selected', and 'non-selected'. The default value is FALSE.}
}
\value{
An array with similar dimensions as the \code{x} input, but with 
 trimmed or dropped dimensions.
}
\description{
This function allows to subset (i.e. slice, take a chunk of) an array, in a 
similar way as done in the function \code{take()} in the package plyr. There
are two main snprovements:\cr\cr First, the input array can have dimension 
names, either in \code{names(dim(x))} or in the attribute 'dimensions'. If 
both exist, \code{names(dim(x))} is prioritized. The dimensions to subset
along can be specified via the parameter \code{along} either with integer
indices or either by their name.\cr\cr Second, there are additional ways to
adjust which dimensions are dropped in the resulting array: either to drop
all, to drop none, to drop only the ones that have been sliced or to drop
only the ones that have not been sliced.\cr\cr
}
\examples{
#Example synthetic data:
# Dimension has name already
data <- 1:(2 * 3 * 372 * 1)
dim(data) <- c(time = 372, lon = 2, lat = 3, model = 1)
data_subset <- Subset(data, c('time', 'model'), 
                     list(1:10, TRUE), drop = 'selected')
dim(data_subset)
# Use attributes 'dimensions'
data <- array(1:(2 * 3 * 372 * 1), dim = c(2, 3, 372, 1))
attributes(data)[['dimensions']] <- c('lat', 'lon', 'time', 'model')
data_subset <- Subset(data, c('lon', 'lat'), list(1, 1), drop = TRUE)
dim(data_subset)

}
