% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cepstral.R
\name{ols_get}
\alias{ols_get}
\title{Ordinary Least Squares Estimator for Log-Spectral Regression}
\usage{
ols_get(X, f, frq, nbase)
}
\arguments{
\item{X}{A numeric matrix of predictors (N x P).}

\item{f}{A numeric matrix of cepstral coefficients.}

\item{frq}{A vector of frequencies in \code{[0,1]}.}

\item{nbase}{Number of Fourier basis functions.}
}
\value{
A list containing:
\describe{
\item{\code{alph}}{Intercept vector.}
\item{\code{bet}}{OLS coefficient matrix.}
\item{\code{spechat}}{Estimated smoothed log-spectra.}
\item{\code{res}}{Matrix of residuals.}
}
}
\description{
Performs OLS regression to estimate the association between covariates
and cepstral coefficients.
}
\examples{
frq <- seq(0, 1, length.out = 16)[2:8]
n <- 10
p <- 3
nbase <- 5
X <- matrix(rnorm(n * p), n, p)
f <- matrix(rnorm(n * nbase), n, nbase)

ols_result <- ols_get(X, f, frq, nbase)

}
