% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cepstral.R
\name{data_generater}
\alias{data_generater}
\title{Generate Time Series}
\usage{
data_generater(N, nobs, spec)
}
\arguments{
\item{N}{Number of time series to generate.}

\item{nobs}{Number of time points.}

\item{spec}{Spetral density matrix.}
}
\value{
Matrix of size \code{nobs × N} of generated time series
}
\description{
Simulates real-valued time series using the Cramér spectral representation and inverse FFT.
}
\examples{
set.seed(123)
N    <- 3
nobs <- 20
freqs <- (1:nobs) / nobs

spec <- matrix(NA, nrow = nobs, ncol = N)
for (i in 1:N) {
  spec[, i] <- exp(2 * cos(2 * pi * freqs) + rnorm(1, sd = 0.1))
}

data_generater(N = N, nobs = nobs, spec = spec)

}
