% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcap_data_out.R
\name{redcap_data_out}
\alias{redcap_data_out}
\title{Combines exported REDCap raw and label .csv files together with data dictionary.
Tranforms the exported data into Excel sheets by survey instrument with one
row per participant}
\usage{
redcap_data_out(
  protocol,
  pullDate = NULL,
  subjID,
  subjID_ineligText = NULL,
  subjID_eligPattern = NULL,
  varFilter = NULL,
  varFilter_eligPattern = NULL,
  setWD_files,
  setWD_dataDict = NULL,
  outDir
)
}
\arguments{
\item{protocol}{study protocol name (i.e. Example_Study)}

\item{pullDate}{date of data pull. For example, 2024_01_02 (if provided)}

\item{subjID}{key identifier field(s) for participant ID in data sets}

\item{subjID_ineligText}{character text that denotes participant IDs to exclude
using first key identifier field. For example, c("New Subject") (if provided)}

\item{subjID_eligPattern}{character text that denotes pattern for participant
IDs to include using first key identifier field. For example, c("^Site_A")
(if provided)}

\item{varFilter}{field to use for filtering data (if provided)}

\item{varFilter_eligPattern}{character text that denotes pattern for filter
variable to include. For example, c("^Arm_A") (if provided)}

\item{setWD_files}{directory where the both raw and label REDCap export .csv
files are stored, following the convention for file names of
1_DATA.csv, 1_DATA_LABELs.csv, 2_DATA.csv, 2_DATA_LABELs.csv, etc}

\item{setWD_dataDict}{directory where the REDCap .csv data dictionary is stored.
Make sure that file is saved as CSV UTF-8 comma delimited.
Must contain "ictionary" in file name (if provided)}

\item{outDir}{output directory where the Excel files are saved}
}
\value{
two Excel files, one containing variable names and labels and the
other containing REDCap survey instrument data by sheet
}
\description{
Combines exported REDCap raw and label .csv files together with data dictionary.
Tranforms the exported data into Excel sheets by survey instrument with one
row per participant
}
\examples{
\dontrun{
redcap_data_out(protocol="Example_Study",pullDate="2024_01_03",
}

}
\keyword{dataframe}
