% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous_2g.R
\name{continuous_2g}
\alias{continuous_2g}
\title{Bivariate analysis for 2 groups}
\usage{
continuous_2g(
  data,
  groupvar,
  ttest_args = list(),
  wilcox_args = list(),
  flextableformat = TRUE
)
}
\arguments{
\item{data}{Data frame from which variables will be extracted.}

\item{groupvar}{Grouping variable as character. Must have exactly 2 levels.}

\item{ttest_args}{Arguments to be passed to \code{t.test()} function.}

\item{wilcox_args}{Arguments to be passed to \code{wilcox.test()} function.}

\item{flextableformat}{Logical operator to indicate the output desired. Default is TRUE. When FALSE, function will return a dataframe format.}
}
\value{
Returns a dataframe or flextable of 2 groups 2 sided Mann Whitney's U or T test, along with Shapiro-Wilk's p values and Levene's p value.
}
\description{
Automatic test for continuous variables for 2 groups. Variable names can be assigned using \code{\link[table1:label]{table1::label()}} function.
}
\examples{
 df <- mtcars
 df$am <- as.factor(df$am)
 continuous_2g(data = df,
 groupvar = "am",
 flextableformat = FALSE)

# Set names to variables
if(requireNamespace("table1")){
table1::label(df$mpg) <- "Miles per gallon"
table1::label(df$cyl) <- "Number of cylinders"
table1::label(df$disp) <- "Displacement"
table1::label(df$hp) <- "Gross horsepower"
table1::label(df$drat) <- "Rear axle ratio"

continuous_2g(data = df, groupvar = "am", flextableformat = FALSE)
}
}
