% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countryOutliers.R
\name{countryOutlieRs}
\alias{countryOutlieRs}
\title{Flag country-level outliers with a provided checklist.}
\usage{
countryOutlieRs(
  checklist = NULL,
  data = NULL,
  keepAdjacentCountry = TRUE,
  pointBuffer = NULL,
  scale = 50,
  stepSize = 1e+06,
  mc.cores = 1
)
}
\arguments{
\item{checklist}{A data frame or tibble. The formatted checklist which was built based on the Discover Life website.}

\item{data}{A data frame or tibble. The a Darwin Core occurrence dataset.}

\item{keepAdjacentCountry}{Logical. If TRUE, occurrences in countries that are adjacent to checklist countries will be
kept. If FALSE, they will be flagged.}

\item{pointBuffer}{Numeric. A buffer around points to help them align with a country or coastline.
This provides a good way to retain points that occur right along the coast or borders of the
maps in rnaturalearth}

\item{scale}{Numeric. The value fed into the map scale parameter for
\code{\link[rnaturalearth:ne_countries]{rnaturalearth::ne_countries()}}'s scale parameter:
Scale of map to return, one of 110, 50, 10 or 'small', 'medium', 'large', where smaller numbers
are higher resolution. WARNING: This function is tested on 110 and 50.}

\item{stepSize}{Numeric. The number of occurrences to process in each chunk. Default = 1000000.}

\item{mc.cores}{Numeric. If > 1, the function will run in parallel
using mclapply using the number of cores specified. If = 1 then it will be run using a serial
loop. NOTE: Windows machines must use a value of 1 (see ?parallel::mclapply). Additionally,
be aware that each thread can use large chunks of memory. If the cores throw issues, consider
setting mc.cores to 1.
Default = 1.}
}
\value{
The input data with two new columns, .countryOutlier or .sea. There are three possible
values for
the new column: TRUE == passed, FALSE == failed (not in country or in the ocean),
NA == did not overlap with rnaturalearth map.
}
\description{
This function flags country-level outliers using the checklist provided with this package.
For additional context and column names, see \code{\link[=beesChecklist]{beesChecklist()}}.
}
\examples{
library(magrittr)
  # Load in the test dataset
beesRaw <- BeeBDC::beesRaw
  # For the sake of this example, use the testChecklist
system.file("extdata", "testChecklist.rda", package="BeeBDC") |> load()
  # For real examples, you might download the beesChecklist from FigShare using 
  #  [BeeBDC::beesChecklist()]

beesRaw_out <- countryOutlieRs(checklist = testChecklist,
                               data = beesRaw \%>\%
                               dplyr::filter(dplyr::row_number() \%in\% 1:50),
                               keepAdjacentCountry = TRUE,
                               pointBuffer = 1,
                               scale = 50,
                               stepSize = 1000000,
                               mc.cores = 1)
table(beesRaw_out$.countryOutlier, useNA = "always")
}
