% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formattedCombiner.R
\name{formattedCombiner}
\alias{formattedCombiner}
\title{Combine the formatted USGS data with the main dataset}
\usage{
formattedCombiner(path, strings, existingOccurrences, existingEMLs)
}
\arguments{
\item{path}{A directory as character. The directory to look in for the formatted USGS data.}

\item{strings}{A regex string. The string to find the most-recent formatted USGS dataset.}

\item{existingOccurrences}{A data frame. The existing occurrence dataset.}

\item{existingEMLs}{An EML file. The existing EML data file to be appended.}
}
\value{
A list with the combined occurrence dataset and the updated EML file.
}
\description{
Merges the Darwin Core version of the USGS dataset that was created using \code{\link[=USGS_formatter]{USGS_formatter()}}
with the main dataset.
}
\examples{
\dontrun{
DataPath <- tempdir()
strings = c("USGS_DRO_flat_27-Apr-2022")
    # Combine the USGS data and the existing big dataset
Complete_data <- formattedCombiner(path = DataPath, 
                                    strings = strings, 
                                    # This should be the list-format with eml attached
                                    existingOccurrences = DataImp$Data_WebDL,
                                    existingEMLs = DataImp$eml_files) 
                                    }
}
