% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assistnet.R
\name{assistnet}
\alias{assistnet}
\title{Investigates the network of assists-shots in a team}
\usage{
assistnet(
  data,
  assist = "assist",
  player = "player",
  points = "points",
  event.type = "event_type",
  normalize = FALSE,
  period.length = 12,
  time.thr = 0
)
}
\arguments{
\item{data}{a data frame whose rows are field shots and columns are variables to be specified in \code{assist}, \code{player}, \code{points}, \code{event.type} (see Details).}

\item{assist}{character, indicating the name of the variable with players who made the assists, if any.}

\item{player}{character, indicating the name of the variable with players who made the shot.}

\item{points}{character, indicating the name of the variable with points.}

\item{event.type}{character, indicating the name of the variable with type of event (mandatory categories are \code{"miss"} for missed field shots and \code{"shot"} for field goals).}

\item{normalize}{logical, if \code{TRUE} the number of assists is normalized (default \code{normalize=FALSE}, see Details).}

\item{period.length}{numerical, the length of a quarter in minutes (default: 12 minutes as in NBA)}

\item{time.thr}{numerical,  Minimum number of minutes played together by a pair of players required for computing their normalized assist count. Pairs below \code{time.thr} are excluded to avoid inflation due to small denominators (default: \code{time.thr = 0}).}
}
\value{
A \code{list} with 3 elements, \code{assistTable} (a table), \code{nodeStats} (a data frame), and \code{assistNet} (a network object). See Details.

\code{assistTable}, the cross-table of assists made and received by the players.

\code{nodeStats}, a data frame with the following variables:

\itemize{
\item \code{FGM} (fields goals made),
}

\itemize{
\item \code{FGM_AST} (field goals made thanks to a teammate's assist),
}

\itemize{
\item \code{FGM_ASTp} (percentage of \code{FGM_AST} over \code{FGM}),
}

\itemize{
\item \code{FGPTS} (points scored with field goals),
}

\itemize{
\item \code{FGPTS_AST} (points scored thanks to a teammate's assist),
}

\itemize{
\item \code{FGPTS_ASTp} (percentage of \code{FGPTS_AST} over \code{FGPTS}),
}

\itemize{
\item \code{AST} (assists made),
}

\itemize{
\item \code{ASTPTS} (point scored by assist's teammates).
}

\code{minTable}, a square matrix with the total number of minutes played in attack by each pair of players; the elements on the principal diagonal are set to zero.

\code{assistminTable}, a matrix showing the assist frequency between player pairs, adjusted for minutes played together in attack and expressed per \code{4*period.length} minutes.

\code{assistNet}, an object of class \code{network} that can be used for further network analysis with specific R packages (see \code{\link[network]{network}})
}
\description{
The \code{assistnet} command provides a comprehensive analysis of a team's assist-shot network, revealing crucial insights into player interactions and on-court dynamics. \loadmathjax
}
\details{
The \code{data} data frame could also be a play-by-play dataset provided that rows corresponding to events different from field shots are not coded as \code{"shot"} in the \code{event.type} variable. (To be completed)

Normalization: \mjdeqn{4 \cdot \text{(period.length)} \cdot  \frac{(\text{number of assists})}{\text{(minutes played in attack by each couple of players)}}}{4  (period.length) (number of assists)/(minutes played in attack by each couple of players)}
}
\examples{
PbP <- PbPmanipulation(PbP.BDB)
PbP.GSW <- subset(PbP, team=="GSW")
out <- assistnet(PbP.GSW)
plot(out)
\dontrun{
  out <- assistnet(PbP.GSW, normalize=TRUE, time.thr=50)
  plot(out, edge.thr=5)
}
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.

P. Zuccolotto, M. Manisera and M. Sandri (2026) Advanced Basketball Data Science: With Applications in R. CRC Press.
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
