% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{sd_10}
\alias{sd_10}
\title{Mean standard deviation of wood density estimates at different taxonomic levels}
\format{
A data frame with 3 observations on the following 2 variables:
\itemize{
\item \code{taxo}: Character vector with the different taxonomical levels (family, genus, species)
\item \code{sd}: Numeric vector giving the mean standard deviation of wood density values
}
}
\usage{
data("sd_10")
}
\description{
This dataset gives the mean standard deviation of wood density values of the \link{wdData} dataset
at different taxonomical levels only considering taxa having more than 10 different values.
This dataset is used in the function \code{\link[=getWoodDensity]{getWoodDensity()}} to associate at the appropriate taxonomic
level a mean error to wood density estimate.
}
\details{
This dataset is used in the function \code{\link[=getWoodDensity]{getWoodDensity()}}.
}
\examples{
data(sd_10)
str(sd_10)
}
\references{
Rejou-Mechain et al. (2017).
\emph{BIOMASS: An R Package for estimating above-ground biomass and its uncertainty in tropical forests}.
Methods in Ecology and Evolution, 8 (9), 1163-1167.
}
\keyword{datasets}
\keyword{getWoodDensity}
\keyword{internal}
\keyword{wdData}
