% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_feat_clin.R
\name{plot_feat_clin}
\alias{plot_feat_clin}
\title{Plot BEAM Feature}
\usage{
plot_feat_clin(
  feat.id,
  beam.result,
  beam.specs = NULL,
  beam.set.pvals,
  beam.feat.pvals,
  n.row = NULL,
  n.col = NULL
)
}
\arguments{
\item{feat.id}{A character specifying the name of a feature. Must be in beam.result$beam.data$set.data}

\item{beam.result}{A beam.stats object from compute_beam_stats}

\item{beam.specs}{A data.frame. Default NULL, in which case beam.result$beam.specs is used. Otherwise can input other beam.specs  data.frame that must contain name, mtx, mdl, plot columns.}

\item{beam.set.pvals}{A list containing BEAMR set p-values from compute_set_pvalues.}

\item{beam.feat.pvals}{A list containing feature-level p-values from compute_feature_pvalues.}

\item{n.row}{A numeric. Specify the number of rows for the plot layout; default NULL will automatically define the number of rows after number of columns specified.}

\item{n.col}{A numeric. Specify the number of columns for the plot layout; default NULL will use the number of omics types.}
}
\value{
A figure (ggarrange object)
}
\description{
plot_feat_clin produces a matrix of feature level clinical plots for a specific feature.
}
\examples{
data(beam_stats)
test.pvals <- compute_set_pvalues(beam.stats=beam_stats)
test.feat.pvals <- compute_feature_pvalues(beam.stats=beam_stats)
plot.specs <- prep_beam_plot(beam.data=beam_stats$beam.data, beam.specs=beam_stats$beam.specs)
test.plot <- plot_feat_clin(beam.result=beam_stats, beam.specs=plot.specs,
                            beam.set.pvals=test.pvals, beam.feat.pvals=test.feat.pvals,
                            feat.id="ENSG00000227443_loss",
                            n.col=2, n.row=NULL)
}
