% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_set_pvalues.R
\name{compute_set_pvalues}
\alias{compute_set_pvalues}
\title{Compute BEAMR p-values for sets}
\usage{
compute_set_pvalues(
  beam.stats,
  peel = FALSE,
  z = TRUE,
  alpha = 0.1,
  mess.freq = 25
)
}
\arguments{
\item{beam.stats}{A beam.stats object from compute_beam_stats function}

\item{peel}{Logical indicating whether to peel in p-value calculation}

\item{z}{Logical indicating whether to z-scale each vector of one coefficient estimate across bootstraps before analysis}

\item{alpha}{Maximum depth to peel (reduces computing time); default 0.1.}

\item{mess.freq}{Message frequency; default 25.}
}
\value{
A list with a data.frame of set p-values from BEAMR analysis, a data.frame of summary row p-values, and a data frame of set matching.
}
\description{
Compute BEAMR p-values for sets
}
\examples{
data(beam_stats_sm)
test.pvals <- compute_set_pvalues(beam.stats=beam_stats_sm)
}
