% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_prepare_data_or.R
\name{do_prepare_data_or}
\alias{do_prepare_data_or}
\title{Prepare data for the offensive rebounds computation}
\usage{
do_prepare_data_or(data, rm_overtime, data_ginfo)
}
\arguments{
\item{data}{Source play-by-play data from a given game.}

\item{rm_overtime}{Logical. Decide to remove overtimes or not.}

\item{data_ginfo}{Games' basic information. If NULL, nothing to add.}
}
\value{
Data frame. Each row represents the action happened in the game. 
The \strong{points} column is added to transform the action
that finished in scoring into numbers.
}
\description{
The computation of the scoring after offensive rebounds requires a 
specifical data preparation. This function does this data processing.
}
\note{
1. Actions are given in Spanish. A bilingual basketball vocabulary (Spanish/English)
is provided in \url{https://www.uv.es/vivigui/docs/basketball_dictionary.xlsx}.

2. The \strong{game_code} column allows us to detect the source website, for example,
\url{https://live.acb.com/es/partidos/103389/jugadas}.
}
\examples{
df0 <- acb_vbc_cz_pbp_2223

df1 <- do_prepare_data_or(df0, TRUE, acb_games_2223_info)
#df1                     

}
\seealso{
\code{\link{do_reb_off_success}}
}
\author{
Guillermo Vinue
}
