% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring.R
\name{chiScores}
\alias{chiScores}
\alias{miScores}
\alias{randScores}
\title{Scoring functions}
\usage{
chiScores(bounds, nbelow, n)

miScores(bounds, nbelow, n)

randScores(bounds, nbelow, n)
}
\arguments{
\item{bounds}{numeric vector giving candidate split bounds in
increasing order}

\item{nbelow}{integer vector giving the number of points below
each candidate split}

\item{n}{the total number of points in the bin to be split}
}
\value{
A vector of scores.
}
\description{
These functions define scores to evaluate candidate
splits along a single margin within a partition.
}
\details{
Scorings

Each of these functions accepts `bounds`, an ordered
numeric vector containing the candidate splits within a bin and
the bin bounds all in increasing order, and `nbelow` which gives
the count of points below each split. `n` is used to determine the
number of points above the split.

This implementation choice was made because AssocBin only considers
splits on observed points. It can be proven that, for any convex
scoring function, the internal maximum will occur at an observed
point. This choice therefore limits the computational search required
to identify and split at the optimal coordinate.
}
\section{Functions}{
\itemize{
\item \code{chiScores()}: A chi-squared statistic score

\item \code{miScores()}: A mutual information score

\item \code{randScores()}: A random score for random splitting

}}
\examples{
vals <- c(2, 5, 12, 16, 19)
chiScores(vals, 1:3, 3)
## same for the miScores
miScores(vals, 1:3, 3)
## random scoring produces different output every time
randScores(vals, 1:3, 3)
randScores(vals, 1:3, 3)
}
\author{
Chris Salahub
}
