% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitters.R
\name{splitX}
\alias{splitX}
\alias{splitY}
\title{Helper functions for marginal splitting}
\usage{
splitX(bin, bd, above, below)

splitY(bin, bd, above, below)
}
\arguments{
\item{bin}{a bin to be split with elements `x`, `y`, `depth`,
`bnds` (list with elements `x` and `y`), `expn`, `n`}

\item{bd}{numeric split point within the bin bounds}

\item{above}{indices of `x` and `y` points in the bin above `bd`}

\item{below}{indices of `x` and `y` points in the bin below `bd`}
}
\value{
A list of two bins resulting from the split of `bin` at
`bds`.
}
\description{
These functions are helpers to safely split bins
along X or Y.
}
\details{
These unexported functions have been defined primarily
to clean up other code, but could be changed to obtain different
core functionality.
}
\section{Functions}{
\itemize{
\item \code{splitX()}: Splitting on x

\item \code{splitY()}: Splitting on y

}}
\author{
Chris Salahub
}
