% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/read.R
\docType{methods}
\name{read_chronomodel}
\alias{read_chronomodel}
\alias{read_chronomodel-method}
\alias{read_chronomodel_events}
\alias{read_chronomodel_events-method}
\alias{read_chronomodel_phases}
\alias{read_chronomodel_phases-method}
\alias{read_chronomodel_events,character-method}
\alias{read_chronomodel_phases,character-method}
\title{Read ChronoModel Output}
\usage{
read_chronomodel_events(file, ...)

read_chronomodel_phases(file, ...)

\S4method{read_chronomodel_events}{character}(file, calendar = CE(), sep = ",", dec = ".")

\S4method{read_chronomodel_phases}{character}(file, calendar = CE(), sep = ",", dec = ".")
}
\arguments{
\item{file}{the name of the file which the data are to be read from.
    Each row of the table appears as one line of the file.  If it does
    not contain an \emph{absolute} path, the file name is
    \emph{relative} to the current working directory,
    \code{\link{getwd}()}. Tilde-expansion is performed where supported.
    This can be a compressed file (see \code{\link{file}}).

    Alternatively, \code{file} can be a readable text-mode
    \link{connection} (which will be opened for reading if
    necessary, and if so \code{\link{close}}d (and hence destroyed) at
    the end of the function call).  (If \code{\link{stdin}()} is used,
    the prompts for lines may be somewhat confusing.  Terminate input
    with a blank line or an \abbr{EOF} signal, \code{Ctrl-D} on Unix and
    \code{Ctrl-Z} on Windows.  Any pushback on \code{stdin()} will be
    cleared before return.)

    \code{file} can also be a complete URL.  (For the supported URL
    schemes, see the \sQuote{URLs} section of the help for
    \code{\link{url}}.)
  }

\item{...}{Further arguments to be passed to \code{read.table}.}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the calendar
(see \code{\link[aion:calendar]{aion::calendar()}}). It should be \code{\link[=CE]{CE()}} unless you change the
default settings in 'ChronoModel'.}

\item{sep}{the field separator character.  Values on each line of the
    file are separated by this character.  If \code{sep = ""} (the
    default for \code{read.table}) the separator is \sQuote{white space},
    that is one or more spaces, tabs, newlines or carriage returns.}

\item{dec}{the character used in the file for decimal points.}
}
\value{
An \code{\linkS4class{EventsMCMC}} or a \code{\linkS4class{PhasesMCMC}} object.
}
\description{
Reads MCMC output.
}
\examples{
if (requireNamespace("ArchaeoData", quietly = TRUE)) {
  ## Import ChronoModel Output
  path <- "chronomodel/ksarakil"

  ## Events
  path_events <- system.file(path, "Chain_all_Events.csv", package = "ArchaeoData")
  (chrono_events <- read_chronomodel_events(path_events))

  ## Phases
  path_phases <- system.file(path, "Chain_all_Phases.csv", package = "ArchaeoData")
  (chrono_phases <- read_chronomodel_phases(path_phases))
}
}
\references{
Lanos, Ph., Philippe, A. & Dufresne, Ph. (2015). Chronomodel:
Chronological Modeling of Archaeological Data using Bayesian Statistics.
URL: \url{https://chronomodel.com/}.
}
\seealso{
\code{\link[utils:read.table]{utils::read.table()}}

Other read methods: 
\code{\link{as_coda}()},
\code{\link{as_events}()},
\code{\link{as_phases}()},
\code{\link{check}},
\code{\link{read_bcal}()},
\code{\link{read_oxcal}()}
}
\author{
T. S. Dye, N. Frerebeau
}
\concept{read methods}
