% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/boundaries.R
\docType{methods}
\name{boundaries}
\alias{boundaries}
\alias{boundaries-method}
\alias{boundaries,numeric,numeric-method}
\alias{boundaries,PhasesMCMC,missing-method}
\title{Phase Time Range}
\usage{
boundaries(x, y, ...)

\S4method{boundaries}{numeric,numeric}(x, y, level = 0.95)

\S4method{boundaries}{PhasesMCMC,missing}(x, level = 0.95)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, \code{x} must be an
\code{\linkS4class{PhasesMCMC}} object.}

\item{...}{Currently not used.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}
}
\value{
The endpoints of the shortest time range (at a given \code{level}).
}
\description{
Computes the shortest interval that satisfies
\eqn{P(PhaseMin < IntervalInf < IntervalSup < PhaseMax | M) = level}
for each phase.
}
\section{Methods (by class)}{
\itemize{
\item \code{boundaries(x = numeric, y = numeric)}: Returns a length-two \code{\link{numeric}} vector
(terminal times).

\item \code{boundaries(x = PhasesMCMC, y = missing)}: Returns a \code{\linkS4class{TimeRange}} object.

}}
\examples{
## Coerce to events
eve <- as_events(mcmc_events, calendar = CE(), iteration = 1)
eve <- eve[1:10000, ]

## Compute min-max range by group
pha <- phases(eve, groups = list(A = c(1, 3), B = c(2, 4)))

## Compute phase ranges
bou <- boundaries(pha)
as.data.frame(bou)

## Compute phase transition
tra <- transition(pha)
as.data.frame(tra)

## Compute phase hiatus
hia <- hiatus(pha)
as.data.frame(hia)
}
\seealso{
Other time ranges: 
\code{\link{hiatus}()},
\code{\link{transition}()}
}
\author{
A. Philippe, M.-A. Vibet, N. Frerebeau
}
\concept{time ranges}
