% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTRW.R
\name{plotTRW}
\alias{plotTRW}
\title{plotTRW}
\usage{
plotTRW(
  inTRW,
  linewidth_TRW = 1,
  linewidth_Ntrees = 1,
  byYears = 20,
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{inTRW}{tibble. The first object resulting from the \code{TRW_readExcel} function.}

\item{linewidth_TRW}{numeric. line size for TRW.}

\item{linewidth_Ntrees}{numeric. line size for Ntrees.}

\item{byYears}{numeric. Spacing (in years) between tick marks on the x-axis of time-related plots.}

\item{xlim}{Optional numeric vector of length 2 specifying the limits of the x-axis.
If \code{NULL} the limits are automatically determined.}

\item{ylim}{Optional numeric vector of length 2 specifying the limits of the y-axis
for the ABD panel. If \code{NULL} the limits are automatically determined.}

\item{...}{Other arguments passed on to methods. Not currently used.}
}
\value{
None. A plot is produced.
}
\description{
Function for plotting TRW values from \code{inTRW} object using the first
\code{tibble} produced by the function \code{TRW_readExcel}.
}
\details{
This function generates a basic plot displaying the mean chronology
+/- standard error of raw tree-ring widths (in mm) alongside
the corresponding number of trees.
}
\examples{

plotTRW(inTRW)

}
\seealso{
\code{\link{plotBAI}}, \code{\link{plotABD}}

Other tree ring plotting: 
\code{\link{plotABD}()},
\code{\link{plotBAI}()}
}
\concept{tree ring plotting}
