% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{plot.as_data}
\alias{plot.as_data}
\title{Plot}
\usage{
\method{plot}{as_data}(
  x,
  labels = NULL,
  test = TRUE,
  predictions = NULL,
  by_families = FALSE,
  stacked = TRUE,
  legend = TRUE,
  color_list = NULL,
  ml_color = NULL,
  path = NULL,
  ...
)
}
\arguments{
\item{x}{object of class \code{as_data}.}

\item{labels}{character vector with the labels for each of the algorithms. If NULL, the y names of the \code{data_object} names will be used.}

\item{test}{flag that indicates whether the function should use test data or training data.}

\item{predictions}{a data frame with the predicted KPI for each algorithm (columns) and for each instance (rows). If NULL, the plot won't include a ML column.}

\item{by_families}{boolean indicating whether the function should represent data by families or not. The family information must be included in the \code{data_object} parameter.}

\item{stacked}{boolean to choose between bar plot and stacked bar plot.}

\item{legend}{boolean to activate or deactivate the legend in the plot.}

\item{color_list}{list with the colors for the plots. If NULL, or insufficient number of colors, the colors will be generated automatically.}

\item{ml_color}{color por the ML boxplot. If NULL, it will be generated automatically.}

\item{path}{path where plots will be saved. If NULL they won't be saved.}

\item{...}{other parameters.}
}
\value{
A list with \code{boxplot}, \code{ranking}, \code{fig_comp}, \code{optml_fig_comp} and \code{optmlall_fig_comp} plots.
}
\description{
For an object of class \code{as_data}, function that makes several plots, including the following: a boxplot, a ranking plot and comparisons between the different options.
}
\examples{
\donttest{
data(branchingsmall)
data <- partition_and_normalize(branchingsmall$x, branchingsmall$y)
training <- AStrain(data, method = "glm")
predict_test <- ASpredict(training, newdata = data$x.test)
plot(data, predictions = predict_test)
}
}
