% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh.R
\name{compute_mh_p_eatq__ss__negaff_mean}
\alias{compute_mh_p_eatq__ss__negaff_mean}
\title{Compute "Early Adolescent Temperament Questionnaire [Parent] (Super scale -
Negative Affect: Combines frustration, depressed mood, and aggression
scales): Mean"}
\usage{
compute_mh_p_eatq__ss__negaff_mean(
  data,
  name = "mh_p_eatq__ss__negaff_mean",
  combine = TRUE
)
}
\arguments{
\item{data}{tbl, Dataframe containing the columns to be summarized.}

\item{name}{character, Name of the new column to be created. Default is
the name in description, but users can change it.}

\item{combine}{logical, append the new computed column to the end
of original tibble? Default is \code{TRUE}.}
}
\value{
tbl. The input data frame with the summary score appended as
a new column.
}
\description{
Computes the summary score \code{mh_p_eatq__ss__negaff_mean}
Early Adolescent Temperament Questionnaire [Parent] (Super scale -
Negative Affect: Combines frustration, depressed mood, and aggression
scales): Mean
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_p_eatq__frust_mean}
\item \code{mh_p_eatq__depm_mean}
\item \code{mh_p_eatq__aggr_mean}
}
\item \emph{Excluded values:} none
}
}
\details{
Negative Affect = Frustration, Depressive Mood, Aggression

In the super scale calculation, no NA is allowed.
}
\examples{
\dontrun{
data |>
  compute_mh_p_eatq__ss__negaff_mean() |>
  select(
    any_of(c(
      "mh_p_eatq__ss__negaff_mean"
    ))
  )
}

}
