
use crate::{util::uninit_slice_fill_zero, Error};
use core::{mem::MaybeUninit, num::NonZeroU32};































































#[macro_export]
macro_rules! register_custom_getrandom {
    ($path:path) => {

        const __GETRANDOM_INTERNAL: () = {

            #[no_mangle]
            unsafe fn __getrandom_custom(dest: *mut u8, len: usize) -> u32 {

                type F = fn(&mut [u8]) -> ::core::result::Result<(), $crate::Error>;
                let _: F = $crate::getrandom;
                let f: F = $path;
                let slice = ::core::slice::from_raw_parts_mut(dest, len);
                match f(slice) {
                    Ok(()) => 0,
                    Err(e) => e.code().get(),
                }
            }
        };
    };
}

#[allow(dead_code)]
pub fn getrandom_inner(dest: &mut [MaybeUninit<u8>]) -> Result<(), Error> {
    extern "Rust" {
        fn __getrandom_custom(dest: *mut u8, len: usize) -> u32;
    }





    let dest = uninit_slice_fill_zero(dest);
    let ret = unsafe { __getrandom_custom(dest.as_mut_ptr(), dest.len()) };
    match NonZeroU32::new(ret) {
        None => Ok(()),
        Some(code) => Err(Error::from(code)),
    }
}
