% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xp.akaike.plot.R, R/xp.cook.R,
%   R/xp.ind.inf.fit.R, R/xp.ind.inf.terms.R, R/xp.ind.stud.res.R, R/xp.plot.R,
%   R/xp.summary.R
\name{GAM_summary_and_plot}
\alias{GAM_summary_and_plot}
\alias{xp.akaike.plot}
\alias{xp.cook}
\alias{xp.ind.inf.fit}
\alias{xp.ind.inf.terms}
\alias{xp.ind.stud.res}
\alias{xp.plot}
\alias{xp.summary}
\title{GAM functions for Xpose 4}
\usage{
xp.akaike.plot(
  gamobj = NULL,
  title = "Default",
  xlb = "Akaike value",
  ylb = "Models",
  ...
)

xp.cook(gam.object)

xp.ind.inf.fit(
  gamobj = NULL,
  plot.ids = TRUE,
  idscex = 0.7,
  ptscex = 0.7,
  title = "Default",
  recur = FALSE,
  xlb = NULL,
  ylb = NULL,
  ...
)

xp.ind.inf.terms(
  gamobj = NULL,
  xlb = NULL,
  ylb = NULL,
  plot.ids = TRUE,
  idscex = 0.7,
  ptscex = 0.7,
  prompt = TRUE,
  ...
)

xp.ind.stud.res(
  gamobj = NULL,
  title = "Default",
  recur = FALSE,
  xlb = NULL,
  ylb = NULL
)

xp.plot(
  gamobj = NULL,
  plot.ids = TRUE,
  idscex = 0.7,
  ptscex = 0.7,
  prompt = TRUE,
  ...
)

xp.summary(gamobj = NULL)
}
\arguments{
\item{gamobj}{A GAM object to use in the plot. IF null then the user is
asked to choose from a list of GAM objects in memory.}

\item{title}{A text string indicating plot title. If \code{NULL}, left
blank.}

\item{xlb}{A text string indicating x-axis legend. If \code{NULL}, left
blank.}

\item{ylb}{A text string indicating y-axis legend. If \code{NULL}, left
blank.}

\item{\dots}{Other arguments passed to the GAM functions.}

\item{gam.object}{A GAM object (see \code{\link[gam]{gam}}.}

\item{plot.ids}{Logical, specifies whether or not ID numbers should be
displayed.}

\item{idscex}{ID label size.}

\item{ptscex}{Point size.}

\item{recur}{If dispersion should be used in the GAM object.}

\item{prompt}{Specifies whether or not the user should be prompted to press
RETURN between plot pages. Default is TRUE.}

\item{object}{An xpose.data object.}
}
\value{
Plots or summaries.
}
\description{
These are functions for summarizing and plotting the results of 
the generalized additive model within Xpose
}
\section{Functions}{
\itemize{
\item \code{xp.akaike.plot()}: An Akaike plot of the results.

\item \code{xp.cook()}: Individual parameters to GAM fit.

\item \code{xp.ind.inf.fit()}: Individual influence on GAM fit.

\item \code{xp.ind.inf.terms()}: Individual influence on GAM terms.

\item \code{xp.ind.stud.res()}: Studentized residuals.

\item \code{xp.plot()}: GAM residuals of base model vs. covariates.

\item \code{xp.summary()}: Summarize GAM.

}}
\seealso{
\code{\link[gam]{gam}}, \code{\link[lattice]{dotplot}}

Other GAM functions: 
\code{\link{xp.get.disp}()},
\code{\link{xp.scope3}()},
\code{\link{xpose.bootgam}()},
\code{\link{xpose.gam}()},
\code{\link{xpose4-package}}
}
\author{
Niclas Jonsson & Andrew Hooker
}
\concept{GAM functions}
