% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covwv.R
\name{wccv}
\alias{wccv}
\title{Cross Covariance of Matrix}
\usage{
wccv(x, decomp = "modwt", filter = "haar", nlevels = NULL)
}
\arguments{
\item{x}{A \code{vector} with dimensions N x M.}

\item{decomp}{A \code{string} that indicates whether to use the "dwt" or "modwt" decomposition.}

\item{filter}{A \code{string} that specifies what wavelet filter to use.}

\item{nlevels}{An \code{integer} that indicates the level of decomposition. It must be less than or equal to floor(log2(length(x))).}
}
\value{
Returns a \code{matrix} of \code{lists} of all the possible pair cross-covariance, variance of each wavelet cross-covariance and its 95% CI.
}
\description{
Calculates the Cross-covariance between multiple wavelet transfomations (dwt or modwt)
}
\details{
If \code{nlevels} is not specified, it is set to \eqn{\left\lfloor {{{\log }_2}\left( {length\left( x \right)} \right)} \right\rfloor}{floor(log2(length(x)))}
}
\author{
Justin Lee
}
