% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readers.R
\name{read_yaml_in_workspace}
\alias{read_yaml_in_workspace}
\title{Read YAML Object from a Workspace.}
\usage{
read_yaml_in_workspace(x, name, subdir = NULL)
}
\arguments{
\item{x}{the workspace}

\item{name}{name associated with the YAML file stored in the workspace}

\item{subdir}{Optional subdirectory used for the asset to retrieve}
}
\value{
A list object as read from the stored YAML file.
}
\description{
Read a YAML file stored as a list object in a workspace.
Returns the YAML content as an R list object.
}
\examples{
library(workspace)
dir_tmp <- tempfile(pattern = "ws")
z <- new_workspace(dir = dir_tmp)

config_list <- list(
  database = list(
    host = "localhost",
    port = 5432
  ),
  settings = list(
    debug = TRUE,
    max_connections = 100
  )
)
z <- store_yaml(
  x = z,
  list = config_list,
  filename = "config.yaml",
  name = "app_config",
  timestamp = "2023-11-12 11:37:41",
  subdir = "configs"
)
read_yaml_in_workspace(z, "app_config", subdir = "configs")
}
\seealso{
\link{workspace} for package documentation

Other functions to read in a workspace: 
\code{\link{list_object_in_workspace}()},
\code{\link{read_dataset_in_workspace}()},
\code{\link{read_json_str_in_workspace}()},
\code{\link{read_raster_in_workspace}()},
\code{\link{read_rds_in_workspace}()},
\code{\link{read_timestamp}()}
}
\concept{functions to read in a workspace}
