% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readers.R
\name{read_json_str_in_workspace}
\alias{read_json_str_in_workspace}
\title{Read JSON String from a Workspace.}
\usage{
read_json_str_in_workspace(x, name, subdir = NULL)
}
\arguments{
\item{x}{the workspace}

\item{name}{name associated with the json file stored in the workspace}

\item{subdir}{Optional subdirectory used for the asset to retrieve}
}
\value{
A character string containing the JSON string.
}
\description{
Read a JSON file a dataset stored as a text file
in a workspace.
}
\examples{
library(workspace)
dir_tmp <- tempfile(pattern = "ws")
z <- new_workspace(dir = dir_tmp)
z <- store_dataset(x = z, dataset = iris, name = "iris_dataset")
z <- store_dataset(x = z, dataset = mtcars, name = "mtcars")
json_str <- paste0("{\"first_name\": \"John\",\"last_name\": \"Smith\",\"is_alive\": true,",
"\"age\": 27, \"address\": { \"street_address\": \"21 2nd Street\",",
"\"city\": \"New York\",\"state\": \"NY\",\"postal_code\": \"10021-3100\"",
"}}")
z <- store_json(
  x = z,
  json_str = json_str,
  filename = "example.json",
  name = "an_example",
  timestamp = "2023-11-12 11:37:41",
  subdir = "blah"
)
read_json_str_in_workspace(z, "an_example")
}
\seealso{
\link{workspace} for package documentation

Other functions to read in a workspace: 
\code{\link{list_object_in_workspace}()},
\code{\link{read_dataset_in_workspace}()},
\code{\link{read_raster_in_workspace}()},
\code{\link{read_rds_in_workspace}()},
\code{\link{read_timestamp}()},
\code{\link{read_yaml_in_workspace}()}
}
\concept{functions to read in a workspace}
