% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspace.R
\name{unpack_workspace}
\alias{unpack_workspace}
\title{Unpack a workspace}
\usage{
unpack_workspace(file)
}
\arguments{
\item{file}{Packed workspace}
}
\value{
Object of class workspace.
}
\description{
Unpack a compressed file into a workspace object.
}
\examples{
library(workspace)
dir_tmp <- tempfile(pattern = "ws")
z <- new_workspace(dir = dir_tmp)
z <- store_dataset(x = z, dataset = iris, name = "iris_dataset")
z <- store_dataset(x = z, dataset = mtcars, name = "mtcars")
json_str <- paste0("{\"first_name\": \"John\",\"last_name\": \"Smith\",\"is_alive\": true,",
"\"age\": 27, \"address\": { \"street_address\": \"21 2nd Street\",",
"\"city\": \"New York\",\"state\": \"NY\",\"postal_code\": \"10021-3100\"",
"}}")
z <- store_json(
  x = z,
  json_str = json_str,
  filename = "example.json",
  timestamp = "2023-11-12 11:37:41",
  subdir = "blah"
)
z <- store_rds(
  x = z,
  obj = mtcars,
  filename = "obj.rds",
  timestamp = "2023-11-12 11:37:41",
  subdir = "r-object"
)
file <- tempfile(fileext = ".zip")
pack_workspace(x = z, file = file)

z <- unpack_workspace(file = file)
z
}
\seealso{
\link{workspace} for package documentation

Other functions to manage workspaces: 
\code{\link{new_workspace}()},
\code{\link{pack_workspace}()},
\code{\link{workspace_bind}()},
\code{\link{workspace_copy}()}
}
\concept{functions to manage workspaces}
