% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdi_get_income_levels.R
\name{wdi_get_income_levels}
\alias{wdi_get_income_levels}
\title{Download income levels from the World Bank API}
\source{
https://api.worldbank.org/v2/incomeLevels
}
\usage{
wdi_get_income_levels(language = "en")
}
\arguments{
\item{language}{A character string specifying the language code for the API
response (default is "en" for English).}
}
\value{
A tibble with columns that typically include:
\describe{
\item{income_level_id}{An integer identifier for the income level.}
\item{income_level_iso2code}{A character string representing the ISO2 code
for the income level.}
\item{income_level_name}{The description of the income level (e.g.,
"Low income", "High income").}
}
}
\description{
This function returns a tibble of supported income levels for querying the
World Bank API. The income levels categorize countries based on their gross
national income per capita.
}
\details{
This function provides a reference for the supported income levels,
which categorize countries according to their income group as defined by the
World Bank. The language parameter allows the results to be returned in
different languages as supported by the API.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Download all income levels in English
wdi_get_income_levels()
\dontshow{\}) # examplesIf}
}
