% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tab_metrics_items_cor}
\alias{tab_metrics_items_cor}
\title{Output a correlation table for item battery and one metric variable}
\usage{
tab_metrics_items_cor(
  data,
  cols,
  cross,
  method = "pearson",
  digits = 2,
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble.}

\item{cols}{The source columns.}

\item{cross}{The target columns or NULL to calculate correlations within the source columns.}

\item{method}{The output metrics, pearson = Pearson's R, spearman = Spearman's rho.}

\item{digits}{The number of digits to print.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{tab_metrics}.}
}
\value{
A volker tibble.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
library(volker)
data <- volker::chatgpt

tab_metrics_items_cor(
  data,
  starts_with("cg_adoption_adv"),
  sd_age,
  metric = TRUE
)

}
\keyword{internal}
