% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report_metrics}
\alias{report_metrics}
\title{Create table and plot for metric variables}
\usage{
report_metrics(
  data,
  cols,
  cross = NULL,
  metric = FALSE,
  ...,
  index = FALSE,
  factors = FALSE,
  clusters = FALSE,
  effect = FALSE,
  title = TRUE,
  close = TRUE,
  clean = TRUE
)
}
\arguments{
\item{data}{A data frame.}

\item{cols}{A tidy column selection,
e.g. a single column (without quotes)
or multiple columns selected by methods such as starts_with().}

\item{cross}{Optional, a grouping or correlation column (without quotes).}

\item{metric}{When crossing variables, the cross column parameter can contain categorical or metric values.
By default, the cross column selection is treated as categorical data.
Set metric to TRUE, to treat it as metric and calculate correlations.}

\item{...}{Parameters passed to the \link{plot_metrics} and \link{tab_metrics} and \link{effect_metrics} functions.}

\item{index}{When the cols contain items on a metric scale
(as determined by \link{get_direction}),
an index will be calculated using the 'psych' package.
Set to FALSE to suppress index generation.}

\item{factors}{The number of factors to calculate.
Set to FALSE to suppress factor analysis.
Set to TRUE to output a scree plot and automatically choose the number of factors.
When the cols contain items on a metric scale
(as determined by \link{get_direction}),
factors will be calculated using the 'psych' package.
See \link{add_factors}.}

\item{clusters}{The number of clusters to calculate.
Cluster are determined using kmeans after scaling the items.
Set to FALSE to suppress cluster analysis.
Set to TRUE to output a scree plot and automatically choose the number of clusters based on the elbow criterion.
See \link{add_clusters}.}

\item{effect}{Whether to report statistical tests and effect sizes. See \link{effect_counts} for further parameters.}

\item{title}{A character providing the heading or TRUE (default) to output a heading.
Classes for tabset pills will be added.}

\item{close}{Whether to close the last tab (default value TRUE) or to keep it open.
Keep it open to add further custom tabs by adding headers on the fifth level
in Markdown (e.g. ##### Method).}

\item{clean}{Prepare data by \link{data_clean}.}
}
\value{
A volker report object.
}
\description{
Depending on your column selection, different types of plots and tables are generated.
See \link{plot_metrics} and \link{tab_metrics}.
}
\details{
For item batteries, an index is calculated and reported.
When used in combination with the Markdown-template "html_report",
the different parts of the report are grouped under a tabsheet selector.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
library(volker)
data <- volker::chatgpt

report_metrics(data, sd_age)

}
