% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingThemes.R
\name{themeVisOmop}
\alias{themeVisOmop}
\title{Apply a pre-defined visOmopResults theme to a ggplot}
\usage{
themeVisOmop(style = "default", fontsizeRef = 11)
}
\arguments{
\item{style}{Character indicating which pre-defined style to apply. Refer to
the function \code{plotStyle()} to see the available styles.}

\item{fontsizeRef}{An integer to use as reference when adjusting label
fontsize.}
}
\description{
Apply a pre-defined visOmopResults theme to a ggplot
}
\examples{
result <- mockSummarisedResult() |> dplyr::filter(variable_name == "age")

barPlot(
  result = result,
  x = "cohort_name",
  y = "mean",
  facet = c("age_group", "sex"),
  colour = "sex") +
 themeVisOmop()
}
